DROP VIEW [dbo].[V_TELE_ORC_CONFERIDO]
/****** Object:  View [dbo].[V_TELE_ORC_CONFERIDO]    Script Date: 07/06/2012 08:35:29 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_TELE_ORC_CONFERIDO]
			AS
			SELECT A.CD_FILIAL
				 , A.CD_ORC
				 , A.DTHR_PEDIDO
				 , A.ENT_DTHR
				 , DATEDIFF(minute, GETDATE(), A.ENT_DTHR) - C.SAIDA AS PRAZO
				 , 'PD' AS TIPO
				 , A.CD_ROTA
				 , CLI.RZ_CLI
			FROM dbo.TELE_ORC AS A INNER JOIN
				 dbo.V_TELE_TEMPO_ETAPA AS C ON A.CD_TIPO_ENTREGA = C.CD_TIPO_ENTREGA AND A.CD_FILIAL = C.CD_FILIAL INNER JOIN 
				 dbo.RC_CLI CLI ON A.CD_CLI = CLI.CD_CLI
			WHERE A.CD_ETAPAS = 3 AND A.CD_TIPO = 2 
								  
			UNION
			SELECT A.CD_FILIAL
				 , A.CD_OS
				 , A.DTHR
				 , A.DTHR_OS
				 , DATEDIFF(minute, GETDATE(), A.DTHR_OS) AS PRAZO
				 , 'OS' AS TIPO
				 , C.CD_ROTA
				 , CLI.RZ_CLI
			FROM        dbo.TELE_OS AS A INNER JOIN
						dbo.RC_CLI_ROTA_CEP C ON A.CD_CID_LOGRA = C.CD_CID_LOGRA INNER JOIN 
						dbo.TELE_OS_ETAPA AS B ON A.CD_OS = B.CD_OS AND A.CD_OS_ETAPA = B.CD_OS_ETAPA INNER JOIN 
				 dbo.TELE_ORC ORC ON ORC.CD_ORC = A.CD_ORC INNER JOIN 
				 dbo.RC_CLI CLI ON ORC.CD_CLI = CLI.CD_CLI				 				 
			WHERE B.CD_OS_TIPO_STATUS = 2

GO


